/*
    Name............LCD effect
    Version.........1.0
    Description.....Apply fake LCD effect
    Author..........llcheesell (scripting template by Lian)
*/


(function(){

    /*---------------------------------------------------------------------------------------------------------*/    
    function initGlobals(G)
    /*---------------------------------------------------------------------------------------------------------*/
    {                
        G.NAME                      =   "LCDeffect.jsx";
        G.TITLE                     =   "LCDeffect";
        //-----------------------------------------------------------------------------------------------------
        G.NO_PROJ_ERR               =   {en:"Open a project first.", jp:"プロジェクトを開いて下さい."};
        G.NO_COMP_ERR               =   {en:"Select a composition.", jp:"コンポジションを選択して下さい."};
        G.NO_LAYER_ERR              =   {en:"Select at least one layer.", jp:"少なくとも1つのレイヤーを選択して下さい."};
    }
    
    /*---------------------------------------------------------------------------------------------------------*/
    function loc(str) // Language check ( En or Jp)
    /*---------------------------------------------------------------------------------------------------------*/
    {
        return app.language == Language.JAPANESE ? str["jp"] : str["en"];
    }
    
    /*---------------------------------------------------------------------------------------------------------*/
    function throwMsg(msg) // alert error
    /*---------------------------------------------------------------------------------------------------------*/
    {
        alert(loc(msg), G.TITLE);
    }
    
    /*---------------------------------------------------------------------------------------------------------*/
    function LCDeffect(comp)
    /*---------------------------------------------------------------------------------------------------------*/
    {       
		var actLayer = comp.selectedLayers;
		
		//controller
		var ctrl = comp.layers.addNull();
        ctrl.name = 'ctrl';
		ctrl.Effects.addProperty("ADBE Slider Control").name = "Vslider";
		ctrl.Effects.property("Vslider")(1).setValue(1);
		ctrl.Effects.addProperty("ADBE Slider Control").name = "Hslider";
		ctrl.Effects.property("Hslider")(1).setValue(1);
		ctrl.Effects.addProperty("ADBE Slider Control").name = "Resolution";
		ctrl.Effects.property("Resolution")(1).setValue(1);
		ctrl.Effects.property("Resolution")(1).expression = "if(value==0){1}else{value};";
        ctrl.enabled = false;
		
		actLayer[0].blendingMode = BlendingMode.ADD;
		
		actLayer[0].Effects.addProperty("ADBE Shift Channels")(3).setValue(10);
		actLayer[0].Effects.property("ADBE Shift Channels")(4).setValue(10);
		
		actLayer[0].Effects.addProperty("ADBE Mosaic")(1).expression = "r=thisComp.layer('ctrl').effect('Resolution')(1);thisComp.width/3/r;";
		actLayer[0].Effects.property("ADBE Mosaic")(2).expression = "r=thisComp.layer('ctrl').effect('Resolution')(1);thisComp.height/9/r;";
		
		actLayer[0].Effects.addProperty("ADBE Grid").name = "Grid V";
		actLayer[0].Effects.property("Grid V")(1).setValue([0,0]);
		actLayer[0].Effects.property("Grid V")(3).expression = "r=thisComp.layer('ctrl').effect('Resolution')(1);[3*r,5000];";
		actLayer[0].Effects.property("Grid V")(6).setValue(2);
		actLayer[0].Effects.property("Grid V")(11).setValue(1);
		actLayer[0].Effects.property("Grid V")(12).setValue([0,0,0,0]);
		actLayer[0].Effects.property("Grid V")(14).setValue(2);
		actLayer[0].Effects.property("Grid V").name = "Grid V";
		
		actLayer[0].Effects.addProperty("ADBE Grid").name = "Grid H";
		actLayer[0].Effects.property("Grid H")(1).setValue([0,0]);
		actLayer[0].Effects.property("Grid H")(3).expression = "r=thisComp.layer('ctrl').effect('Resolution')(1);[5000,9*r];";
		actLayer[0].Effects.property("Grid H")(6).setValue(4);
		actLayer[0].Effects.property("Grid H")(11).setValue(0);
		actLayer[0].Effects.property("Grid H")(12).setValue([0,0,0,0]);
		actLayer[0].Effects.property("Grid H")(14).setValue(2);
		
		actLayer[0].Effects.addProperty("ADBE Offset");
		actLayer[0].Effects.addProperty("ADBE Glo2")(2).setValue(30);
		actLayer[0].Effects.property("ADBE Glo2")(3).setValue(3);
		actLayer[0].Effects.property("ADBE Glo2")(4).setValue(2);
		
		actLayer[0].duplicate();
		actLayer[0].duplicate();

		var index =actLayer[0].index;

		//B
		comp.layer(index-2).name = "B";
		comp.layer(index-2).Effects.property("ADBE Shift Channels")(2).setValue(10);
		comp.layer(index-2).Effects.property("ADBE Shift Channels")(3).setValue(10);
		comp.layer(index-2).Effects.property("ADBE Shift Channels")(4).setValue(4);
		
		comp.layer(index-2).Effects.property("ADBE Offset")(1).expression = "v=thisComp.layer('ctrl').effect('Vslider')(1);h=thisComp.layer('ctrl').effect('Hslider')(1);[thisLayer.width/2+v,thisLayer.height/2+h]";
		
		//G
		comp.layer(index-1).name = "G";
		comp.layer(index-1).Effects.property("ADBE Shift Channels")(2).setValue(10);
		comp.layer(index-1).Effects.property("ADBE Shift Channels")(3).setValue(3);
		comp.layer(index-1).Effects.property("ADBE Shift Channels")(4).setValue(10);
		
		comp.layer(index-1).Effects.property("ADBE Offset")(1).expression = "v=thisComp.layer('ctrl').effect('Vslider')(1);h=thisComp.layer('ctrl').effect('Hslider')(1);[thisLayer.width/2-v,thisLayer.height/2-h]";

		//R
		comp.layer(index).name = "R";
		

		
    }
    
    /*---------------------------------------------------------------------------------------------------------*/
    function main() 
    /*---------------------------------------------------------------------------------------------------------*/
    {
        // check the project opened
        var proj = app.project;
        if (!proj) {
            throwMsg(G.NO_PROJ_ERR);
            return;
        }
        // check the composition selected
        var comp = proj.activeItem;
        if (!comp || !(comp instanceof CompItem)) {
            throwMsg(G.NO_COMP_ERR);
            return;
        }
        // When required, check at least one layer was selected
       if (comp.selectedLayers.length < 1){
           throwMsg(G.NO_LAYER_ERR);
           return;
       }
        
        // Run template() function
        app.beginUndoGroup(G.TITLE);
        LCDeffect(comp);
        app.endUndoGroup();
    }
    
    /*---------------------------------------------------------------------------------------------------------*/
    // Entry Point
    /*---------------------------------------------------------------------------------------------------------*/
    
    var G = new Object();
    initGlobals(G);
    main();

})();
